 ; Ŀ
 ;   C: turbocopier.                                                       
 ;   Copyright 1997, 2005, 2007 by Rocket Software Ltd.                    
 ;   Also Ni, save an entity name.                                         
 ;        Since, make everything since the saved entity the previous set.  
 ;   No relation to the language...well, not much.                         
 ; 

 ; Ŀ
 ;   Subroutine Smack - make an ss of any entities after a given one.      
 ;   Takes the marker ename as an argument, returns an ss.                 
 ;   Note: this routine looks overly baroque.                              
 ; 
 (DEFUN SMACK (aaa / ss bbb)
  (if (setq bbb (entnext aaa))       ; put next ent in new ss
      (setq ss (ssadd bbb)))         ; put next ent in new ss
 ; Ŀ
 ;   If the entity is an insert and there are attributes:                  
 ; 
  (if (and bbb
           (= (cdr (assoc 0 (entget bbb))) "INSERT")
           (= (cdr (assoc 66 (entget bbb))) 1))
 ; Ŀ
 ;   Then find the seqend before assuming entnext will give the next ent.  
 ; 
      (progn
           (while (/= (cdr (assoc 0 (entget bbb))) "SEQEND")
                  (setq bbb (entnext bbb)))))
 ; Ŀ
 ;   Find all entities after the marker point, put them in an ss.          
 ; 
  (while (and bbb (entnext bbb))        ; while there are entities
         (setq bbb (entnext bbb))       ; find the next new entity
         (ssadd bbb ss)                 ; add it to the selection set
         (if (and (= (cdr (assoc 0 (entget bbb))) "INSERT")
                  (= (cdr (assoc 66 (entget bbb))) 1))
             (progn
                  (while (/= (cdr (assoc 0 (entget bbb))) "SEQEND")
                         (setq bbb (entnext bbb))))))
  ss)
 ; Ŀ
 ;   Smack end.                                                            
 ; 

 ; Ŀ
 ;   Ni: save the last entity name to a variable.                          
 ; 
 (DEFUN C:NI (/ bbb)
 ; Ŀ
 ;   Find the last entity, save its ename.                                 
 ; 
  (setq a_a (entlast))
  (while (setq bbb (entnext a_a))
         (setq a_a bbb))
 (princ))
 ; Ŀ
 ;   Ni end.                                                               
 ; 

 ; Ŀ
 ;   Since: make everything since a_a into the previous selection set.     
 ; 
 (DEFUN C:SINCE (/ ss num)
 ; Ŀ
 ;   Get an ss of the new entities, make them the previous selection set.  
 ; 
 (cond ((null a_a)
        (prompt "\nNo saved start entity.  Please run Ni."))
       ((null (setq ss (smack a_a)))
        (prompt "\nNo entities have been created since the saved one."))
       (T
        (command ".select" ss "")
        (setq num (sslength ss))
        (prompt (strcat "\nPrevious selection set size: "
                        (itoa num) " entit"
                        (if (= num 1) "y." "ies.")))))
 (princ))
 ; Ŀ
 ;   Since end.                                                            
 ; 

 ; Ŀ
 ;   C.                                                                    
 ; 
 (DEFUN C:C (/ aaa bbb 2ss snp *error* ss sss num)
 ; Ŀ
 ;   Find the last entity, save its ename.                                 
 ; 
  (setq aaa (entlast))
  (while (setq bbb (entnext aaa))
         (setq aaa bbb))
 ; Ŀ
 ;   Calling a command will kill grips, so must see if anything is         
 ;   gripped before starting Undo.                                         
 ; 
  (setq 2ss (ssgetfirst))
 ; Ŀ
 ;   Now start the undo group and make an error handler.                   
 ; 
  (command ".undo" "be")
  (setq snp (getvar "snapmode"))
  (defun *error* (shk /)
   (setvar "snapmode" snp)
   (setvar "cmdecho" 0)
   (command ".undo" "end")
  (princ))
 ; Ŀ
 ;   Find or make a selection set.                                         
 ; 
  (setq ss (car 2ss))
  (setq sss (cadr 2ss))
  (cond ((and ss sss)
         (setq num 0)
         (while (setq enam (ssname ss num))
                (setq num (1+ num))
                (ssadd enam ss)))
        (sss (setq ss sss))
        ((null ss)
         (setvar "snapmode" 0)
         (setq ss (ssget))
         (setvar "snapmode" snp)))
 ; Ŀ
 ;   Copy it.                                                              
 ; 
  (if ss
     (progn
          (command "copy" ss "" "m")
          (setvar "cmdecho" 1)
          (while (/= (getvar "cmdactive") 0)
                 (command pause))
 ; Ŀ
 ;   Get an ss of the new entities, make them the previous selection set.  
 ; 
           (setq ss (smack aaa))
           (command ".select" ss ""))
 ; Ŀ
 ;   Or else print an acknowledgement of failure.                          
 ; 
     (prompt "\nNothing selected."))
 ; Ŀ
 ;   End neatly.                                                           
 ; 
  (*error*)
 (princ))